local t = Def.ActorFrame{};
local PN = ... ;

local function DisplayCorrectSpeedMod()
	local sDisplay
	local XMod = GAMESTATE:GetPlayerState(PN):GetCurrentPlayerOptions():XMod()
	local CMod = GAMESTATE:GetPlayerState(PN):GetCurrentPlayerOptions():CMod()
	local MMod = GAMESTATE:GetPlayerState(PN):GetCurrentPlayerOptions():MMod()

	if XMod then sDisplay = "X"..string.format("%0.3f",XMod) end
	if CMod then sDisplay = "C"..CMod end
	if MMod then sDisplay = "M"..MMod end
	return sDisplay
end

t[#t+1] = Def.ActorFrame{
	CommonNormal()..{
		Name="NoteSpacingName";
		InitCommand=cmd(y,Top()+145.5;visible,false;align,1,0;zoom,0.4;diffuse,PlayerColor(PN);shadowlength,1);
		OnCommand=function(self)
			if PN == PLAYER_1 then self:x(CenterX()-156) else self:x(Right()-15) end
			self:settext(DisplayCorrectSpeedMod())	
		end;
		OptionsMenuChangedMessageCommand=function(self,params,pn) if params.Player == PN then if params.Menu == "PlayerOptions" then self:visible(true) else self:visible(false) end end end;
		OptionsListClosedMessageCommand=function(self,params,pn) if params.Player == PN then self:visible(false) end end;
		SpeedModChangedMessageCommand=cmd(playcommand,"On");
	};
	CommonNormal()..{
		Name="NoteSkinName";
		InitCommand=cmd(y,Top()+145.5+16;visible,false;align,1,0;zoom,0.4;diffuse,PlayerColor(PN);shadowlength,1);
		OnCommand=function(self)
			local NoteSkin = GAMESTATE:GetPlayerState(PN):GetCurrentPlayerOptions():NoteSkin()
			if PN == PLAYER_1 then self:x(CenterX()-156) else self:x(Right()-15) end
			self:settext(string.upper(NoteSkin))
		end;
		OptionsMenuChangedMessageCommand=function(self,params,pn) if params.Player == PN then if params.Menu == "PlayerOptions" then self:visible(true) else self:visible(false) end end end;
		OptionsListClosedMessageCommand=function(self,params,pn) if params.Player == PN then self:visible(false) end end;
		NoteSkinChangedMessageCommand=cmd(playcommand,"On");
	};
	CommonNormal()..{
		Name="NoteSizeName";
		InitCommand=cmd(y,Top()+145.5+16*2;visible,false;align,1,0;zoom,0.4;diffuse,PlayerColor(PN);shadowlength,1);
		OnCommand=function(self)
			local Mini = GAMESTATE:GetPlayerState(PN):GetCurrentPlayerOptions():Mini()
			if PN == PLAYER_1 then self:x(CenterX()-156) else self:x(Right()-15) end
			self:settext(string.format("%02.f",Mini * -100).."%")	
		end;
		OptionsMenuChangedMessageCommand=function(self,params,pn) if params.Player == PN then if params.Menu == "PlayerOptions" then self:visible(true) else self:visible(false) end end end;
		OptionsListClosedMessageCommand=function(self,params,pn) if params.Player == PN then self:visible(false) end end;
		NoteSizeChangedMessageCommand=cmd(playcommand,"On");
	};
};

return t